{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 12.08.98 - 13:22:38 $                                        =}
{========================================================================}
unit Unit2;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  ComCtrls,
  Tabnotbk,
  StdCtrls,
  ExtCtrls,
  MMSystem,
  MMObj,
  MMUtils,
  MMSlider,
  MMRegs,
  MMWaveIO,
  MMWavIn,
  MMWavOut,
  MMSpin;

type
  TPreferencesForm = class(TForm)
    PageControl1: TPageControl;
    OptAudio: TTabSheet;
    btnOk: TButton;
    btnCancel: TButton;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    PlayCombo: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label6: TLabel;
    radioDevice: TRadioButton;
    radioThread: TRadioButton;
    radioInterrupt: TRadioButton;
    labelBufferSize: TLabel;
    sliderBufferSize: TMMSlider;
    spinBufferSize: TMMSpinButton;
    procedure FormShow(Sender: TObject);
    procedure BufferSizeChange(Sender: TObject);
    procedure btnOkClick(Sender: TObject);
  private
    BufferSize: integer;

    procedure UpdateBufferSize;
  end;

var
  PreferencesForm: TPreferencesForm;

implementation

uses unit1;

{$R *.DFM}

{========================================================================}
{  Initialization and Settings                                           }
{========================================================================}

{-- TPreferencesForm ----------------------------------------------------}
procedure TPreferencesForm.FormShow(Sender: TObject);
var
   i: integer;

begin
   with MainForm do
   begin
      {-- Audio Page --}
      sliderBufferSize.Position    := AVIControl.NumBuffers;
      spinBufferSize.Value         := sliderBufferSize.Position;
      BufferSize                   := sliderBufferSize.Position*AVIControl.BufferSize;
      UpdateBufferSize;

      if WaveOutGetNumDevs > 0 then
      begin
         PlayCombo.Items.Add(WaveOutGetDeviceName(WAVE_MAPPER));
         for i := 0 to WaveOutGetNumDevs-1 do
         begin
            PlayCombo.Items.Add(WaveOutGetDeviceName(i));
         end;
         PlayCombo.ItemIndex := AVIControl.DeviceId+1;
      end;

      if not _Win95_ then radioInterrupt.Enabled := False;

      case AVIControl.CallbackMode of
          cmWindow  : radioDevice.Checked := True;
          cmThread  : radioThread.Checked := True;
          cmCallback: radioInterrupt.Checked := True;
      end;
   end;
end;

{-- TPreferencesForm ----------------------------------------------------}
procedure TPreferencesForm.btnOkClick(Sender: TObject);
begin
   with MainForm do
   begin
      {-- Audio Page --}
      AVIControl.DeviceID := PlayCombo.ItemIndex-1;
      AVIControl.NumBuffers  := BufferSize div AVIControl.BufferSize;

      if radioDevice.Checked then
         AVIControl.CallbackMode := cmWindow
      else if radioThread.Checked then
         AVIControl.CallbackMode := cmThread
      else
         AVIControl.CallbackMode := cmCallback
   end;
end;

{========================================================================}
{  Audio Page                                                            }
{========================================================================}

{-- TPreferencesForm ----------------------------------------------------}
procedure TPreferencesForm.UpdateBufferSize;
begin
   labelBufferSize.Caption  := IntToStr(BufferSize div 1024)+' Kb';
   if (MainForm.AVIControl.PWaveFormat <> nil) then
      labelBufferSize.Caption  := labelBufferSize.Caption+ Format(' - %f seconds',
                                  [wioBytesToTime(MainForm.AVIControl.PWaveFormat,BufferSize)/1000]);
end;

{-- TPreferencesForm ----------------------------------------------------}
procedure TPreferencesForm.BufferSizeChange(Sender: TObject);
begin
   if (Sender = sliderBufferSize) then
       spinBufferSize.Value := sliderBufferSize.Position
   else
       sliderBufferSize.Position := spinBufferSize.Value;

   BufferSize := sliderBufferSize.Position * MainForm.AVIControl.BufferSize;

   UpdateBufferSize;
end;

end.


